#pragma once

#include "log.h"

#include "region.h"
#include "maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/transform/id_manager.h"

#include <boost/program_options/options_description.hpp>
#include <boost/program_options/variables_map.hpp>

#include <string>
#include <vector>


namespace maps::wiki::json2ymapsdf {

const std::string STDIN_FILENAME = "-";
const std::string STDOUT_FILENAME = "-";

struct Params {
    Params();

    std::string connStr;
    std::string schema;
    std::string transformCfg;
    std::string printConfigurationFile;
    std::string tmpDir;
    std::string jsonDir;
    std::string jsonFile;
    std::string jsonList;
    bool deleteJson{false};
    bool split{false};
    bool overallValidation{false};
    RegionIds regionIds;
    size_t threadCount;
    std::string experiment;
};

class Options {
public:
    Options(int argc, char* argv[]);
    bool needHelp() const { return needHelp_; }
    const boost::program_options::options_description& desc() const { return desc_; }
    const Params& params() const { return params_; }
private:
    boost::program_options::variables_map vm_;
    boost::program_options::options_description desc_;
    bool needHelp_;
    Params params_;
};

} // namespace maps::wiki::json2ymapsdf
