#include "region.h"
#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/string_utils.h>

#include <map>

namespace maps::wiki::json2ymapsdf {

namespace {
const std::string REGION_STATUS_EXPORT = "export";
const std::string REGION_STATUS_SKIP = "skip";
const std::string REGION_STATUS_FAILED = "failed";
} // namespace

Region::Status toRegionStatus(const std::string& str)
{
    static const std::map<std::string, Region::Status> string2status = {
        {REGION_STATUS_EXPORT, Region::Status::Export},
        {REGION_STATUS_SKIP, Region::Status::Skip},
        {REGION_STATUS_FAILED, Region::Status::Failed},
    };

    const auto it = string2status.find(str);
    REQUIRE(it != string2status.end(), "Unknown region status: '" << str << "'");
    return it->second;
}

std::string toString(Region::Status status)
{
    switch (status) {
        case Region::Status::Export:
            return REGION_STATUS_EXPORT;
        case Region::Status::Skip:
            return REGION_STATUS_SKIP;
        case Region::Status::Failed:
            return REGION_STATUS_FAILED;
    }
}

std::string Region::info() const
{
    std::ostringstream oss;
    oss << "Region id = " << id << ", "
        << "status = " << toString(status) << ", "
        << "isocodes = {"
        << common::join(isoCodes, ", ")
        << "}";
    return oss.str();
}

} // namespace maps::wiki::json2ymapsdf
