#pragma once

#include <string>
#include <vector>

namespace maps::wiki::json2ymapsdf {

using RegionId = std::string;
using RegionIds = std::vector<RegionId>;

struct Region {
    enum class Status {
        Export,
        Skip,
        Failed
    };

    RegionId id{};
    std::vector<std::string> isoCodes;
    Status status{Status::Skip};

    std::string info() const;
};

Region::Status toRegionStatus(const std::string& str);
std::string toString(Region::Status status);

using Regions = std::vector<Region>;

} // namespace maps::wiki::json2ymapsdf
