#include "item.h"
#include "json_helper.h"

namespace maps::wiki::json2ymapsdf::tds {

namespace {
const std::string EMPTY_STRING;
} // namespace

Item::Item(const json::Value& jsonObject)
    : attributes_(readAttributes(jsonObject))
{
    if (jsonObject.hasField(JSON_FIELD_GEOMETRY)) {
        const auto& geoJson = jsonObject[JSON_FIELD_GEOMETRY];
        attributes_[ATTRIBUTE_SHAPE] = geoJson2Wkb(geoJson);
    }
    if (jsonObject.hasField(JSON_FIELD_DESCRIPTION)) {
        attributes_[ATTRIBUTE_DESCRIPTION] =
            jsonObject[JSON_FIELD_DESCRIPTION].toString();
    }
}

const std::string&
Item::operator [](const std::string& attributeName) const
{
    const auto& it = attributes_.find(attributeName);
    if (it == attributes_.end()) {
        return EMPTY_STRING;
    } else {
        return it->second;
    }
}

std::string Item::info() const
{
    std::string infoStr;
    for (const auto& attr: attributes_) {
        infoStr += infoStr.empty() ? "[" : ", ";
        infoStr += "'" + attr.first + "'='" + attr.second + "'";
    }
    infoStr += "]";
    return infoStr;
}

} // namespace maps::wiki::json2ymapsdf::tds
