#pragma once
#include "schema.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/transform/id_manager.h>
#include <maps/libs/json/include/value.h>
#include <string>
#include <set>
#include <map>
#include <vector>

namespace maps::wiki::json2ymapsdf::tds {

class Item {
public:
    explicit Item(const json::Value& jsonObject);
    virtual ~Item() = default;

    const std::string& operator [](const std::string& attributeName) const;
    bool operator < (const Item& rhs) const { return attributes_ < rhs.attributes_; }

    std::string info() const;

protected:
    Item() = default;
    std::map<std::string, std::string> attributes_;
};

} // namespace maps::wiki::json2ymapsdf::tds
