#pragma once
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/transform/id_manager.h>
#include "schema.h"
#include <maps/libs/json/include/value.h>
#include <string>
#include <set>
#include <map>

namespace maps::wiki::json2ymapsdf::tds {

const json::Value& getObjects(const json::Value& json);
const json::Value& getLinks(const json::Value& jsonObject);
DBID nextFreeObjectId(const json::Value& json);
std::string geoJson2Wkb(const json::Value& geoJson);
schema::RelationsMode relationsMode(const json::Value& json);
std::map<std::string, std::string> readAttributes(const json::Value& jsonObject);
schema::Categories readCategories(const json::Value& jsonObject);

std::string attributeName(const std::string& fullAttr);
std::string categoryName(const std::string& fullAttr);

const std::string JSON_FIELD_MASTER = "master";
const std::string JSON_FIELD_SLAVE = "slave";
const std::string JSON_FIELD_DESCRIPTION = "description";
const std::string JSON_FIELD_GEOMETRY = "geometry";

json::Value readJson(const std::string& jsonFile);

} // namespace maps::wiki::json2ymapsdf::tds
