#include "link.h"
#include "json_helper.h"

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::json2ymapsdf::tds {

Link::Link(const json::Value& jsonLink, const std::string& objectId)
    : Item(jsonLink)
    , relation_(schema::relation(
        attributes_[ATTRIBUTE_MASTER_CATEGORY],
        attributes_[ATTRIBUTE_ROLE]))
{
    if(jsonLink.hasField(JSON_FIELD_SLAVE)) {
        attributes_[ATTRIBUTE_MASTER_ID] = objectId;
        attributes_[ATTRIBUTE_SLAVE_ID] =
            jsonLink[JSON_FIELD_SLAVE].toString();
    } else if(jsonLink.hasField(JSON_FIELD_MASTER)) {
        attributes_[ATTRIBUTE_MASTER_ID] =
            jsonLink[JSON_FIELD_MASTER].toString();
        attributes_[ATTRIBUTE_SLAVE_ID] = objectId;
    }

    for (const auto& [key, value]: relation_.constAttributes()) {
        attributes_.try_emplace(key, value);
    }
}

Link::Link(const schema::Relation& relation, const std::string& objectId)
    : relation_(relation)
{
    REQUIRE(relation_.direction() != schema::RelationsDirection::Unknown,
        "Unable to create null relation of unknown direction");

    attributes_[ATTRIBUTE_MASTER_CATEGORY] = relation_.master().name();
    attributes_[ATTRIBUTE_ROLE] = relation_.role();
    attributes_[ATTRIBUTE_SLAVE_CATEGORY] = relation_.slave().name();
    attributes_[ATTRIBUTE_RELATION_STUB] = VALUE_TRUE;

    if (relation_.direction() == schema::RelationsDirection::MasterToSlave) {
        attributes_[ATTRIBUTE_MASTER_ID] = objectId;
    } else {
        attributes_[ATTRIBUTE_SLAVE_ID] = objectId;
    }

    // no const attributes for stub
}

} // namespace maps::wiki::json2ymapsdf::tds
