#pragma once
#include "item.h"
#include "link.h"
#include <maps/libs/json/include/value.h>
#include <string>
#include <set>
#include <map>
#include <vector>

namespace maps::wiki::json2ymapsdf::tds {

class Object : public Item {
public:
    Object(const json::Value& jsonObject, const std::string& objectId);
    virtual ~Object() = default;

    const schema::Categories& categories() const { return categories_; }

    using Links = std::map<schema::Relation, std::set<Link>>;
    const Links& links() const { return links_; }

private:
    schema::Categories categories_;
    Links links_;
};

} // namespace maps::wiki::json2ymapsdf::tds
