#include "attach_ymapsdf.h"
#include "schema.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/config.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/config_helper.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/tds/json_helper.h>

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <set>

namespace maps::wiki::json2ymapsdf::tds::schema {

namespace {

const ymapsdf::schema::Table&
primaryTable(const ymapsdf::schema::Column& column)
{
    ASSERT(column.isPrimary() || column.foreignPtr() != nullptr);

    return column.foreignPtr() != nullptr
        ? *column.foreignPtr()
        : column.table();
}

bool
match(const Relation& tRel, const ymapsdf::schema::Relation& yRel)
{
    return tRel.master().tablePtr() == &primaryTable(yRel.master())
        && tRel.slave().tablePtr() == &primaryTable(yRel.slave());
}

bool
conflicts(const Relation& tRel, const ymapsdf::schema::Relation& yRel)
{
    return
        (tRel.master().tablePtr() != &primaryTable(yRel.master())
            && tRel.master().tablePtr() != nullptr)
        || (tRel.slave().tablePtr() != &primaryTable(yRel.slave())
            && tRel.slave().tablePtr() != nullptr);
}

const ymapsdf::schema::Relation*
selectRelation(const ymapsdf::schema::Relations& ymapsdfRelations, const Relation& tRel)
{
    std::set<const ymapsdf::schema::Relation*> filteredRelations;

    // collect all relations, matched by master&slave category/table
    for (const auto& yRel: ymapsdfRelations) {
        if (match(tRel, yRel)) {
            filteredRelations.insert(&yRel);
        }
    }

    if (filteredRelations.size() == 1) {
        // return the only matched ymapsdf::relation
        return *filteredRelations.begin();
    } else if (filteredRelations.size() > 1) {
        // exclude relations without correspondent config rule for tds relations
        for (auto it = filteredRelations.begin(); it != filteredRelations.end(); ) {
            bool corresponds = false;
            for (auto cfgNode: config::nodes(tRel)) {
                if (config::corresponds(**it, cfgNode)) {
                    corresponds = true;
                    break;
                }
            }
            if (corresponds) {
                ++it;
            } else {
                it = filteredRelations.erase(it);
            }
        }
    } else { // filteredRelations.size() == 0
        // collect ymapsdf relations with correspondence in config
        // without conflict with tds relation
        for (const auto& yRel: ymapsdfRelations) {
            for (auto cfgNode: config::nodes(tRel)) {
                if (!conflicts(tRel, yRel) && config::corresponds(yRel, cfgNode)) {
                    filteredRelations.insert(&yRel);
                    break;
                }
            }
        }
    }

    if (filteredRelations.size() == 1) {
        return *filteredRelations.begin();
    }

    return nullptr;
}

} // namespace

void
attachYmapsdfSchema(const ymapsdf::schema::Schema& ymapsdfSchema)
{

    for(const auto& kv: categories()) {
        auto category = kv.second;
        auto mainTableName = config::mainTableName(*category);
        if (!mainTableName.empty()) {
            category->attachTable(&ymapsdfSchema.table(mainTableName));
        }
    }

    for(const auto& kv: relations()) {
        auto relation = kv.second;
        relation->attachRelation(selectRelation(ymapsdfSchema.relations(), *relation));
    }
}

} // namespace maps::wiki::json2ymapsdf::tds::schema
