#include "schema.h"
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::json2ymapsdf::tds::schema {

Category::Category(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& name)
    : name_(name)
    , table_(nullptr)
{
    if (ymapsdfSchema.hasTable(name)) {
        table_ = &ymapsdfSchema.table(name);
    }
}

void
Category::addAttribute(const std::string& attribute)
{
    REQUIRE (!attribute.empty(), "Unable to configure empty attribute");
    attributes_.insert(attribute);
}

bool
Category::operator < (const Category& other) const
{
    return name() < other.name();
}

void
Category::addConstAttr(const std::string& attribute, const std::string& value)
{
    addAttribute(attribute);
    constAttributes_[attribute] = value;
}

std::string
Category::info() const
{
    std::ostringstream infoStr;

    infoStr << "'" << name() << "', ";

    if (table_ == nullptr) {
        infoStr << "no linked toble, ";
    } else {
        infoStr << "linked to " << table_->name();
    }

    infoStr << ", attribues: [";
    for(const auto& attribute: attributes_) {
        infoStr << attribute << ", ";
    }
    for(const auto& kv: constAttributes_) {
        infoStr << "*" << kv.first << "=" << kv.second << ", ";
    }
    infoStr << "]";

    infoStr << ", grouped relations {";
    for (const auto& relation: relations_) {
       infoStr << relation->name() << ", ";
    }
    infoStr << "}";
    return infoStr.str();
}

} // namespace maps::wiki::json2ymapsdf::tds::schema
