#pragma once
#include "relation.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/helpers.h>

#include <string>
#include <set>
#include <map>
#include <memory>

namespace maps::wiki::json2ymapsdf::tds::schema {

class Category {
public:
    Category() = delete;
    Category(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& name);
    const std::string& name() const { return name_; }
    const ymapsdf::schema::Table* tablePtr() const { return table_; }
    void addRelation(const std::shared_ptr<Relation>& rel) { relations_.insert(rel); }

    const Relations& relations() const { return relations_; }
    bool operator <(const Category& r) const;

    void addAttribute(const std::string& attribute);
    void addConstAttr(const std::string& attribute, const std::string& value);
    const std::set<std::string>& attributes() const { return attributes_; }
    const std::map<std::string, std::string>& constAttributes() const { return constAttributes_; }

    void attachTable(const ymapsdf::schema::Table* table) { table_ = table; }

    std::string info() const;

private:
    std::string name_;
    std::set<std::string> attributes_;
    Relations relations_;
    const ymapsdf::schema::Table* table_;
    std::map<std::string, std::string> constAttributes_;
};

using CategoryMap = std::map<std::string, std::shared_ptr<Category>>;
using Categories = std::set<const Category *, PtrLess<Category>>;

} // namespace maps::wiki::json2ymapsdf::tds::schema
