#pragma once
#include "relmode.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema.h>

#include <string>
#include <set>
#include <map>
#include <memory>

namespace maps::wiki::json2ymapsdf::tds::schema {

class Category;

class Relation {
public:
    Relation() = delete;
    Relation(
        const Category& master,
        std::string role,
        const Category& slave,
        RelationsDirection direction = RelationsDirection::Unknown);

    const Category& master() const { return master_; }
    const std::string& role() const { return role_; }
    const Category& slave() const { return slave_; }

    RelationsDirection direction() const { return direction_; }
    void setDirection(RelationsDirection direction) { direction_ = direction; }

    const ymapsdf::schema::Relation* ymapsdfRelation() const { return attachedYmapsdfRelation_; }
    void attachRelation(const ymapsdf::schema::Relation* yRel) { attachedYmapsdfRelation_ = yRel; }

    void addAttribute(const std::string& attribute);
    void addConstAttr(const std::string& attribute, const std::string& value);
    const std::set<std::string>& attributes() const { return attributes_; }
    const std::map<std::string, std::string>& constAttributes() const { return constAttributes_; }

    std::string name() const;

    bool operator < (const Relation& other) const;

    std::string info() const;

private:
    const Category& master_;
    std::string role_;
    const Category& slave_;
    RelationsDirection direction_;
    const ymapsdf::schema::Relation* attachedYmapsdfRelation_;
    std::set<std::string> attributes_;
    std::map<std::string, std::string> constAttributes_;
};

using RelationDescriptor = std::pair<std::string, std::string>;
using RelationMap = std::map<RelationDescriptor, std::shared_ptr<Relation>>;
using Relations = std::set<std::shared_ptr<Relation>>;

} // namespace maps::wiki::json2ymapsdf::tds::schema
