#pragma once
#include <string>
#include <set>
#include <iostream>

namespace maps::wiki::json2ymapsdf::tds::schema {

enum class RelationsDirection {
    Unknown,
    MasterToSlave,
    SlaveToMaster
};

class RelationsMode {
public:
    RelationsMode() = default;
    RelationsMode(RelationsDirection mainDirection, const std::string& invertedRoles);
    RelationsMode& operator = (const RelationsMode&) = default;

    friend bool operator == (const RelationsMode& m1, const RelationsMode& m2);


    RelationsDirection mainDirection() const { return mainDirection_; }
    std::string invertedRoles() const;
    RelationsDirection direction(const std::string& role);

    bool unknown() const;

    std::string info() const;

private:
    RelationsDirection mainDirection_{RelationsDirection::Unknown};
    std::set<std::string> invertedRoles_;
};

bool operator != (const RelationsMode& m1, const RelationsMode& m2);

std::istream& operator >> (std::istream& is, RelationsDirection& direction);
std::ostream& operator << (std::ostream& os, const RelationsDirection& direction);

} // namespace maps::wiki::json2ymapsdf::tds::schema
