#pragma once
#include "relation.h"
#include "category.h"
#include "attach_ymapsdf.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema.h>

namespace maps::wiki::json2ymapsdf::tds {

namespace schema {

void configure(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& editorCfg, const RelationsMode& relationsMode);

void discardRelationsDirection();
Category& category(const std::string& catName);
const Relation& relation(const std::string& master, const std::string& role);
Relations getRelations(const std::string& master, const std::string& role);
void checkRelation(const std::string& master, const std::string& role);
const CategoryMap& categories();
const RelationMap& relations();
RelationsMode relationsMode();
std::string info();

void addRelation(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& master, const std::string& role, const std::string& slave);

} // namespace schema

const std::string VALUE_TRUE = "1";
const std::string VALUE_FALSE = "";

const std::string ATTRIBUTE_OBJECT_ID = "OBJECT_ID";
const std::string ATTRIBUTE_MASTER_ID = "MASTER_OBJECT_ID";
const std::string ATTRIBUTE_SLAVE_ID = "SLAVE_OBJECT_ID";
const std::string ATTRIBUTE_ROLE = "role";
const std::string ATTRIBUTE_SHAPE = "shape";
const std::string ATTRIBUTE_DESCRIPTION = "DESCRIPTION";
const std::string ATTRIBUTE_MASTER_CATEGORY = "master";
const std::string ATTRIBUTE_SLAVE_CATEGORY = "slave";
const std::string ATTRIBUTE_RELATION_STUB = "RELATION_STUB";
const std::string ATTRIBUTE_CATEGORY = "category"; // |-delimited for multicategorial objects

const std::string ARRAY_DELIM = "|";

} // namespace maps::wiki::json2ymapsdf::tds
