#include "field_common.h"
#include "field_generate_id.h"

#include <boost/lexical_cast.hpp>

namespace maps::wiki::json2ymapsdf::transformers {

namespace {
const std::string ATTR_ANY_VALUE = "*";
} // namespace

Condition::Condition(const xml3::Node& ifNode)
{
    for (const auto& attr: config::getAttrs(ifNode)) {
        checks_.push_back({attr, config::getValue(ifNode, attr)});
    }
}

Condition::Condition(const std::string& attr)
{
    checks_.push_back({attr, ATTR_ANY_VALUE});
}

bool
Condition::validFor(const tds::Item& item) const
{
    for (const auto& check: checks_) {
        auto attrValue = item[check.attr];
        if (attrValue == check.value) {
            continue;
        }
        if (check.value == ATTR_ANY_VALUE && !attrValue.empty()) {
            continue;
        }
        return false;
    }
    return true;
}

} // namespace maps::wiki::json2ymapsdf::transformers
