#pragma once
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/transform/incomplete_manager.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/tds/schema.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/params.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/helpers.h>

#include <maps/libs/json/include/value.h>
#include <string>
#include <map>
#include <memory>

namespace maps::wiki::json2ymapsdf::transformers {

struct SQLFix {
    std::string name;
    std::string code;
};

void configure(ymapsdf::schema::Schema& ymapsdfSchema, const Params& params);

class RecordTransformer;
class RecordFixer;

using ObjectTransformers = std::multimap<const tds::schema::Category*, std::shared_ptr<RecordTransformer>, PtrLess<tds::schema::Category>>;
using LinkTransformers = std::multimap<const tds::schema::Relation*, std::shared_ptr<RecordTransformer>, PtrLess<tds::schema::Relation>>;

const ObjectTransformers& objectTransformers();
const LinkTransformers& linkTransformers();
const RecordFixer& fixer(const ymapsdf::schema::Table& table);

const std::vector<SQLFix>& ymapsdfFixers();

} // namespace maps::wiki::json2ymapsdf::transformers
