#include "field_access_id.h"
#include <maps/libs/ymapsdf/include/rd.h>
#include <library/cpp/resource/resource.h>

using namespace maps::ymapsdf::rd;
namespace maps::wiki::json2ymapsdf::transformers {
namespace {
const std::string NO_MOTO_ACCESS = "no_moto_access";
const std::string NO_SCOOTER_ACCESS = "no_scooter_access";
} // namespace

AccessIdField::AccessIdField(const ymapsdf::schema::Column* column)
    : SingleFieldTransformer(column)
{ }

AccessIdField::AccessIdField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode)
    : SingleFieldTransformer(ymapsdfSchema, tableName, fieldNode)
{ }

void
AccessIdField::transform(const tds::Item& object, ymapsdf::Record& record) const
{
    const auto& accessIdStr = object[STR_ACCESS_ID];
    const auto& noMotoAccess = object[NO_MOTO_ACCESS];
    const auto& noScooterAccess = object[NO_SCOOTER_ACCESS];

    if (!noMotoAccess.empty() && !noScooterAccess.empty()) {
        record[column()->id()] = accessIdStr;
        return;
    }

    AccessId accessId = AccessId::None;
    std::istringstream accessIdStream(accessIdStr);
    accessIdStream >> accessId;
    if (noMotoAccess.empty() &&
        AccessId::None != (accessId & AccessId::Car))
    {
        accessId = accessId | AccessId::Moto;
    }
    if (noScooterAccess.empty() &&
        AccessId::None != (accessId & (AccessId::Pedestrian | AccessId::Bicycle)))
    {
        accessId = accessId | AccessId::Scooter;
    }
    std::ostringstream out;
    out << accessId;
    record[column()->id()] = out.str();
}

} // namespace maps::wiki::json2ymapsdf::transformers
