#pragma once
#include "field_common.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema/column.h>

namespace maps::wiki::json2ymapsdf::transformers {

const std::string ACCESS_ID = "ACCESS_ID";
const std::string STR_ACCESS_ID = "access_id";

class AccessIdField: public SingleFieldTransformer {
public:
    AccessIdField(const ymapsdf::schema::Column* column);
    AccessIdField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode);

    void transform(const tds::Item& object, ymapsdf::Record& record) const final;
    std::set<std::string> attributes() const final { return { STR_ACCESS_ID }; }
    std::string name() const final { return ACCESS_ID; }
};

} // namespace maps::wiki::json2ymapsdf::transformers
