#include "field_generate_id.h"

namespace maps::wiki::json2ymapsdf::transformers {

GenerateIdField::GenerateIdField(const ymapsdf::schema::Column* column, const xml3::Node& fieldNode)
    : SingleFieldTransformer(column)
    , tdsAttrName_(config::attrName(fieldNode))
{ }

GenerateIdField::GenerateIdField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode)
    : SingleFieldTransformer(ymapsdfSchema, tableName, fieldNode)
    , tdsAttrName_(config::attrName(fieldNode))
{ }

void
GenerateIdField::transform(const tds::Item& object, ymapsdf::Record& record) const
{
    DBID tdsId = 0;
    if (!tdsAttrName_.empty()) {
        auto attrVal = object[tdsAttrName_];
        if (!attrVal.empty()) {
            tdsId = std::stoul(attrVal);
        }
    }
    record[column()->id()] = idManager().uniqueDBID(tdsId);
}

std::set<std::string>
GenerateIdField::attributes() const
{
    if (tdsAttrName_.empty()) {
        return {};
    }
    return {tdsAttrName_};
}

} // namespace maps::wiki::json2ymapsdf::transformers
