#pragma once
#include "field_common.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema/column.h>

namespace maps::wiki::json2ymapsdf::transformers {

const std::string GENERATE_ID_FIELD = "GENERATE_ID";

class GenerateIdField: public SingleFieldTransformer {
public:
    GenerateIdField(const ymapsdf::schema::Column* column, const xml3::Node& fieldNode);
    GenerateIdField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode);
    void transform(const tds::Item&, ymapsdf::Record& record) const;
    std::set<std::string> attributes() const;
    std::string name() const { return GENERATE_ID_FIELD; }

private:
    std::string tdsAttrName_;
};

} // namespace maps::wiki::json2ymapsdf::transformers
