#include "field_locale.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/data_error.h>
#include <maps/libs/locale/include/convert.h>
#include <boost/lexical_cast.hpp>

namespace maps::wiki::json2ymapsdf::transformers {

namespace {
const std::string LOCALE_LANG = "lang";
const std::string LOCALE_SCRIPT = "script";
const std::string LOCALE_REGION = "region";
const std::string LOCALE_VARIANT = "variant";
} // namespace

LocaleField::LocaleField(
        const ymapsdf::schema::Schema& ymapsdfSchema,
        const std::string& tableName,
        const xml3::Node& fieldNode)
    : tdsAttrName_(config::attrName(fieldNode))
    , table_(&ymapsdfSchema.table(tableName))
{ }

void
LocaleField::transform(const tds::Item& object, ymapsdf::Record& record) const
{
    auto localeVal = object[tdsAttrName_];
    if (localeVal.empty()) {
        return;
    }
    try {
        const auto language = locale::to<locale::Language>(localeVal);
        record[LOCALE_LANG] = locale::toString(language.lang);
        record[LOCALE_SCRIPT] = locale::toString(language.script);
        record[LOCALE_REGION] = locale::toString(language.region);
        record[LOCALE_VARIANT] = locale::toString(language.variant);
    } catch (const std::exception& ex) {
        throw TdsDataError() << "Unable to convert '" << localeVal << "' to locale"
            << ": " << ex.what();
    }
}

ymapsdf::schema::ColumnSet
LocaleField::columns() const
{
    return {
        &(*table_)[LOCALE_LANG],
        &(*table_)[LOCALE_SCRIPT],
        &(*table_)[LOCALE_REGION],
        &(*table_)[LOCALE_VARIANT]};
}

} // namespace maps::wiki::json2ymapsdf::transformers
