#pragma once
#include "field_common.h"

namespace maps::wiki::json2ymapsdf::transformers {

const std::string LOCALE_FIELD = "LOCALE";

class LocaleField: public FieldTransformer {
public:
    LocaleField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode);
    void transform(const tds::Item&, ymapsdf::Record& record) const;
    ymapsdf::schema::ColumnSet columns() const;
    std::set<std::string> attributes() const { return {tdsAttrName_}; }
    std::string name() const { return LOCALE_FIELD; }
private:
    std::string tdsAttrName_;
    const ymapsdf::schema::Table* table_;
};

} // namespace maps::wiki::json2ymapsdf::transformers
