#include "field_rubric.h"
#include <library/cpp/resource/resource.h>

namespace maps::wiki::json2ymapsdf::transformers {

namespace {
const std::string STR_FT_TYPE_ID = "ft_type_id";
} // namespace

RubricField::RubricField(const ymapsdf::schema::Column* column)
    : SingleFieldTransformer(column)
    , mapping_(rubrics::loadExportPoiMapping(NResource::Find(rubrics::RUBRICS_MAPPING_CONFIG_RESOURCE_ID)))
{ }

RubricField::RubricField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode)
    : SingleFieldTransformer(ymapsdfSchema, tableName, fieldNode)
    , mapping_(rubrics::loadExportPoiMapping(NResource::Find(rubrics::RUBRICS_MAPPING_CONFIG_RESOURCE_ID)))
{ }

void
RubricField::transform(const tds::Item& object, ymapsdf::Record& record) const
{
    auto rubricId = object[STR_BUSINESS_RUBRIC_ID];
    if (!rubricId.empty()) {
        record[column()->id()] = rubricId;
    } else {
        auto ftTypeId = object[STR_FT_TYPE_ID];
        if (ftTypeId.empty()) {
            return;
        }
        auto it = mapping_.find(std::stol(ftTypeId));
        if (it == mapping_.end()) {
            return;
        }
        record[column()->id()] = std::to_string(it->second.begin()->rubricId);
    }
}

} // namespace maps::wiki::json2ymapsdf::transformers
