#pragma once
#include "field_common.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema/column.h>
#include <maps/wikimap/mapspro/libs/rubrics/include/mapping_utils.h>

namespace maps::wiki::json2ymapsdf::transformers {

const std::string RUBRIC_FIELD = "RUBRIC";
const std::string STR_BUSINESS_RUBRIC_ID = "business_rubric_id";

class RubricField: public SingleFieldTransformer {
public:
    RubricField(const ymapsdf::schema::Column* column);
    RubricField(const ymapsdf::schema::Schema& ymapsdfSchema, const std::string& tableName, const xml3::Node& fieldNode);
    void transform(const tds::Item& object, ymapsdf::Record& record) const;
    std::set<std::string> attributes() const { return { STR_BUSINESS_RUBRIC_ID }; }
    std::string name() const { return RUBRIC_FIELD; }

private:
    rubrics::RubricMapping mapping_;
};

} // namespace maps::wiki::json2ymapsdf::transformers
