#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/record.h>
#include <maps/libs/xml/include/xml.h>

namespace maps::wiki::json2ymapsdf::transformers {

const std::string DROP_FIXER = "DROP";
const std::string REFUSE_FIXER = "REFUSE";
const std::string FAKE_FT_FIXER = "FAKE_FT";
const std::string TRAFFIC_LIGHT = "TRAFFIC_LIGHT";

ymapsdf::Records fix(const ymapsdf::schema::Schema& ymapsdfSchema, ymapsdf::Record&&);


class RecordFixer {
public:
    RecordFixer() = default;
    virtual ~RecordFixer() = default;

    virtual ymapsdf::Records fix(const ymapsdf::schema::Schema& ymapsdfSchema, ymapsdf::Record&& record) const = 0;

    static std::shared_ptr<RecordFixer> create(const xml3::Node* node);
};

class DropFixer: public RecordFixer {
public:
    DropFixer() = default;
    ~DropFixer() = default;

    ymapsdf::Records fix(const ymapsdf::schema::Schema& ymapsdfSchema, ymapsdf::Record&& record) const;
};

class RefuseFixer: public RecordFixer {
public:
    RefuseFixer() = default;
    ~RefuseFixer() = default;

    ymapsdf::Records fix(const ymapsdf::schema::Schema& ymapsdfSchema, ymapsdf::Record&& record) const;
};

class FakeFtFixer: public RecordFixer {
public:
    FakeFtFixer() = default;
    ~FakeFtFixer() = default;

    ymapsdf::Records fix(const ymapsdf::schema::Schema& ymapsdfSchema, ymapsdf::Record&& ftEdgeRecord) const;
};

class TrafficLightFixer: public RecordFixer {
public:
    TrafficLightFixer() = default;
    ~TrafficLightFixer() = default;

    ymapsdf::Records fix(const ymapsdf::schema::Schema& ymapsdfSchema, ymapsdf::Record&& condRdSeqRecord) const;
};

} // namespace maps::wiki::json2ymapsdf::transformers
