#include "record_ad_recognition.h"
#include <maps/libs/locale/include/i18n_features.h>
#include <maps/libs/locale/include/codes.h>
#include <maps/libs/locale/include/convert.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/string_utils.h>
#include <boost/algorithm/string.hpp>

namespace maps::wiki::json2ymapsdf::transformers {

namespace {

const std::string STR_AD_RECOGNITION = "ad_recognition";
const std::string STR_AD_ID = "ad_id";
const std::string STR_ISOCODE = "isocode";
const std::string STR_RECOGNIZED_BY = "recognition";

const std::string AD_RECOGNITION_001_EXP = "ad_recognition_with_001";
const std::string AD_RECOGNITION_GROUP_MEMBERS_EXP = "ad_recognition_without_group_members";

} // namespace

ymapsdf::Records
AdRecognitionTransformer::transform(const tds::Item& object) const
{
    ymapsdf::Records records;
    const auto& strRecognizedBy = object[STR_RECOGNIZED_BY];
    if (strRecognizedBy.empty()) {
        return records;
    }

    const auto& adId = object[tds::ATTRIBUTE_OBJECT_ID];
    const auto recognizedBy = common::split(strRecognizedBy, tds::ARRAY_DELIM);
    for (const auto& isocode: recognizedBy) {
        auto adRecognition = ymapsdf::Record::defaultRecord(ymapsdfSchema_, STR_AD_RECOGNITION);
        adRecognition[STR_AD_ID] = adId;
        adRecognition[STR_ISOCODE] = isocode;
        records.emplace_back(std::move(adRecognition));
    }
    return records;
}

ymapsdf::schema::TableSet
AdRecognitionTransformer::tables() const
{
    return {&ymapsdfSchema_.table(STR_AD_RECOGNITION)};
}

AdRecognitionTransformer::AdRecognitionTransformer(
    const ymapsdf::schema::Schema& ymapsdfSchema,
    const ymapsdf::schema::Table*,
    const tds::schema::Category*,
    const xml3::Node*)
    : RecordTransformer{ymapsdfSchema}
{ }

} // namespace maps::wiki::json2ymapsdf::transformers
