#pragma once
#include "record_common.h"

namespace maps::wiki::json2ymapsdf::transformers {

class LineTransformer : public RecordTransformer {
public:
    LineTransformer(
        const ymapsdf::schema::Schema& ymapsdfSchema,
        const ymapsdf::schema::Table*,
        const tds::schema::Category*,
        const xml3::Node*);

    ymapsdf::Records transform(const tds::Item&) const override;

    ymapsdf::schema::TableSet tables() const override;

    std::string name() const override { return LINE_RECORD; }

private:
    void processLine(
        DBID objId,
        const std::string& shape,
        ymapsdf::Records& records) const;

    const ymapsdf::schema::Table& objEdgeTable_;
    const ymapsdf::schema::Column& objIdColumn_;
};

} // namespace maps::wiki::json2ymapsdf::transformers
