#pragma once
#include "record_common.h"
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/linear_ring.h>

namespace maps::wiki::json2ymapsdf::transformers {

class PolygonTransformer : public RecordTransformer {
public:
    PolygonTransformer(
        const ymapsdf::schema::Schema& ymapsdfSchema,
        const ymapsdf::schema::Table*,
        const tds::schema::Category*,
        const xml3::Node*);

    ymapsdf::Records transform(const tds::Item&) const override;

    ymapsdf::schema::TableSet tables() const override;

    std::string name() const override { return POLYGON_RECORD; }

private:
    void processPolygon(
        DBID objId,
        const std::string& shape,
        ymapsdf::Records& records) const;

    void processFace(
        DBID objId,
        const geolib3::LinearRing2& linearRing,
        bool isInterior,
        ymapsdf::Records& records) const;

    void processEdge(
        DBID faceId,
        const geolib3::Polyline2& polyline,
        ymapsdf::Records& records) const;

    const ymapsdf::schema::Table& objFaceTable_;
    const ymapsdf::schema::Column& objIdColumn_;
};

} // namespace maps::wiki::json2ymapsdf::transformers
