#include "record_rd_el_lane.h"

#include <yandex/maps/wiki/common/rd/lane.h>
#include <boost/algorithm/string.hpp>

namespace maps::wiki::json2ymapsdf::transformers {

namespace {

struct LaneAttrDir {
    std::string laneAttr;
    std::string dir;
};

const std::vector<LaneAttrDir> PASSES {
    {common::STR_F_LANE, common::STR_F_RD_EL_DIR},
    {common::STR_T_LANE, common::STR_T_RD_EL_DIR}
};
} // namespace

ymapsdf::Records
RdElLaneTransformer::transform(const tds::Item& object) const
{
    ymapsdf::Records records;
    auto rdElId = object[tds::ATTRIBUTE_OBJECT_ID];
    for (const auto& pass : PASSES) {
        auto lanes = common::lanesFromString(object[pass.laneAttr]);
        for (size_t laneNum = 0; laneNum < lanes.size(); ++laneNum) {
            const auto& lane = lanes[laneNum];
            auto rdElLane = ymapsdf::Record::defaultRecord(ymapsdfSchema_, common::STR_RD_EL_LANE);
            rdElLane[common::STR_RD_EL_ID] = rdElId;
            rdElLane[common::STR_RD_EL_DIRECTION] = pass.dir;
            rdElLane[common::STR_LANE_NUM] = std::to_string(laneNum);
            rdElLane[common::STR_LANE_KIND] = std::to_string(static_cast<size_t>(lane.kind()));
            rdElLane[common::STR_LANE_DIRECTION_ID] = std::to_string(lane.directionsId());
            records.push_back(std::move(rdElLane));
        }
    }
    return records;

}

ymapsdf::schema::TableSet
RdElLaneTransformer::tables() const
{
    return {&ymapsdfSchema_.table(common::STR_RD_EL_LANE)};
}

RdElLaneTransformer::RdElLaneTransformer(
    const ymapsdf::schema::Schema& ymapsdfSchema,
    const ymapsdf::schema::Table*,
    const tds::schema::Category*,
    const xml3::Node*)
    : RecordTransformer{ymapsdfSchema}
{ }

} // namespace maps::wiki::json2ymapsdf::transformers
