#include "fix_ymapsdf.h"

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/transformers/configuration.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/data_error.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/helpers.h>

namespace maps::wiki::json2ymapsdf {

void
fixYmapsdf(pgpool3::Pool& pool, const std::string& schema)
{
    const auto setSearchPathQuery = "SET search_path TO " + schema + ", public;";

    bool failed = false;
    auto fail = [&] { failed = true; };

    for (const auto& sqlFix: transformers::ymapsdfFixers()) {
        if (failed) {
            break;
        }
        auto query = setSearchPathQuery + sqlFix.code;
        safeRun(
            "Fixing ymapsdf " + sqlFix.name,
            fail,
            [&]() { execCommitWithRetries(pool, sqlFix.name, query); }
        );
    }

    DATA_REQUIRE(!failed, "Fixing Ymapsdf failed");
}

} // namespace maps::wiki::json2ymapsdf
