#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::wiki::json2ymapsdf::isocode {

class AdGeometryBuilder {
public:
    AdGeometryBuilder(
        pgpool3::Pool& pool,
        const std::string& inSchema,
        const std::string& outSchema);

    void build(size_t levelKind);
    void check(size_t levelKind, double perimeterTolerance);

private:
    pgpool3::Pool& pool_;
    std::string inSchema_;
    std::string outSchema_;

    std::string buildQuery(size_t levelKind) const;
    std::string checkQuery(size_t levelKind) const;
    std::string collectBordersQuery(size_t levelKind) const;
    static std::string levelKindClause(size_t levelKind);

    bool isSchemaExist(const std::string& schema);
    bool isTableExist(const std::string& schema, const std::string& table);
};

} // namespace maps::wiki::json2ymapsdf::isocode
