#include "coverage_builder.h"

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/helpers.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

#include <yandex/maps/coverage5/builder.h>

#include <maps/libs/geolib/include/multipolygon.h>
#include <maps/libs/geolib/include/serialization.h>

#include <boost/filesystem.hpp>

#include <cstdint>

namespace fs = boost::filesystem;

namespace maps::wiki::json2ymapsdf::isocode {

std::string
buildCoverageFile(
    pgpool3::Pool& pool,
    const std::string& schemaName,
    const std::string& tmpDir)
{
    std::string layer = "ymapsdf";
    std::string version = "1";
    fs::path file(tmpDir);
    file /= layer + ".mms." + version;
    INFO() << "Building coverage file: " << file.string();

    auto builder = coverage5::dataLayerBuilder(
        file.string(), layer, version, boost::none);

    auto query =
        "SELECT "
            "ad.ad_id, "
            "isocode, "
            "CASE "
            "WHEN isocode BETWEEN '500' AND '999' THEN "
                "ST_AsBinary(ST_Multi(shape)) "
            "ELSE "
                "ST_AsBinary(ST_Multi(ST_Buffer(shape,0.000002))) "
            "END "
        "FROM " + schemaName + ".ad "
        "JOIN " + schemaName + ".ad_geom USING(ad_id) "
        "WHERE level_kind = 1 "
        "AND g_ad_id IS NULL "
        "AND isocode IS NOT NULL";

    auto rows = readWithRetries(pool, query);
    INFO() << "ad size: " << rows.size();

    int fakeId = 1;
    for (const auto& row : rows) {
        auto id = row[0].as<int64_t>(0);
        auto isocode = row[1].as<std::string>({});
        auto wkb = pqxx::binarystring(row[2]).str();

        try {
            auto geoms = geolib3::WKB::read<geolib3::MultiPolygon2>(wkb);
            DEBUG() << fakeId << "[" << id << "] : " << isocode << " polygons: " << geoms.polygonsNumber();

            builder->addRegion(fakeId, boost::none, boost::none, std::string(isocode), {}, geoms);
        } catch (maps::Exception& e) {
            ERROR() << "invalid geometry, id: " << id << " isocode: " << isocode << " error: " << e;
        }

        ++fakeId;
    }
    builder->build();
    INFO() << "Coverage file: " << file.string() << " builded";
    return file.string();
}

} // namespace maps::wiki::json2ymapsdf::isocode
