#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <memory>
#include <atomic>

namespace maps::wiki::json2ymapsdf::isocode {

class GeometryProcessor
{
public:
    GeometryProcessor(
        pgpool3::Pool& pool,
        const std::string& coverageFile,
        const std::string& schemaName,
        std::shared_ptr<std::atomic<bool>> fail);

    ~GeometryProcessor();

    void processRdEl(size_t threads) const;
    void processRdJc(size_t threads) const;
    void processEdge(size_t threads) const;
    void processNode(size_t threads) const;

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};

} // namespace maps::wiki::json2ymapsdf::isocode
