#pragma once

#include <pqxx/pqxx>

#include <functional>
#include <atomic>
#include <string>
#include <memory>

namespace maps::wiki::json2ymapsdf::isocode {

pqxx::result exec(
    pqxx::transaction_base& work,
    const std::string& query,
    const std::string& funcSignature);

void safeRunner(
    const std::function<void()>& f,
    const std::string& name,
    const std::shared_ptr<std::atomic<bool>>& fail);

void safeRunnerQuiet(
    const std::function<void()>& f,
    const std::string& name,
    const std::shared_ptr<std::atomic<bool>>& fail);

} // namespace maps::wiki::json2ymapsdf::isocode
