#pragma once
#include <maps/libs/json/include/value.h>
#include <boost/utility.hpp>
#include <atomic>
#include <mutex>
#include <unordered_set>

namespace maps::wiki::json2ymapsdf {

using DBID = int64_t;

class IdManager {
public:
    IdManager() = default;

    DBID uniqueDBID();
    DBID uniqueDBID(DBID id);
    void advanceTo(DBID idSequence);

    void roundUp();

private:
    std::atomic<DBID> lastId_{0};
    DBID maxOriginalId_{0};
    std::unordered_set<DBID> requestedIds_;
    std::mutex mutex_;
};

IdManager& idManager();

} // namespace maps::wiki::json2ymapsdf
