#pragma once
#include "record.h"

namespace maps::wiki::json2ymapsdf::ymapsdf {

class Bucket {
public:
    Bucket() = default;
    Bucket(Bucket&&) = default;
    Bucket(const Bucket&) = delete;
    Bucket& operator = (Bucket&&) = default;
    Bucket& operator = (const Bucket&) = delete;

    void push(Record&& record);
    size_t size() const { return records_.size(); }
    bool empty() const { return records_.empty(); }
    const Records& records() const { return records_; }
    const schema::Table* tablePtr() const;

private:
    Records records_;
};

} // namespace maps::wiki::json2ymapsdf::ymapsdf
