#include "db.h"
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::json2ymapsdf::ymapsdf {

std::string
printBucketInsert(const Bucket& bucket)
{
    std::ostringstream os;

    os << bucket.tablePtr()->insertClause()  << std::endl;

    for (const auto& record: bucket.records()) {
        os << record;
        if (&record != &bucket.records().back()) {
            os << "," << std::endl;
        } else {
            os << ";" << std::endl;
        }
    }

    return os.str();
}

std::string
printRecordInsert(const Record& record)
{
    std::ostringstream os;
    os << record.table().insertClause() << record << ";" << std::endl;
    return os.str();
}

std::ostream&
operator << (std::ostream& stream, const Value& value)
{
    if (log8::isEnabled(log8::Level::DEBUG) && value.empty()) {
        stream << " ";
    }
    stream << *value;
    return stream;
}

std::ostream&
operator << (std::ostream& stream, const Record& record)
{
    stream <<  "(";
    bool first = true;
    for (size_t id = 0; id < record.table().size(); ++id) {
        if (!record[id].column().isService()) {
            if (first) {
                first = false;
            } else {
                stream << ", ";
            }
            stream << record[id];
        } else if (log8::isEnabled(log8::Level::DEBUG)) {
            stream << " /*" << record[id] << "*/ ";
        }
    }
    stream << ")";
    return stream;
}

} // namespace maps::wiki::json2ymapsdf::ymapsdf
