#pragma once
#include "value.h"
#include <vector>

namespace maps::wiki::json2ymapsdf::ymapsdf {

class Record {
public:
    explicit Record(const schema::Table* table);
    explicit Record(const schema::Schema& schema, const std::string& tableName);
    Record(Record&&) = default;
    Record(const Record&) = delete;
    Record& operator = (Record&&) = default;
    Record& operator = (const Record&) = delete;

    static Record defaultRecord(const schema::Table& table);
    static Record defaultRecord(const schema::Schema& schema, const std::string& tableName);

    bool operator ==(const Record& other) const;
    bool operator !=(const Record& other) const;
    bool operator <(const Record& other) const;

    Value& operator [](size_t fieldId);
    Value& operator [](const std::string& fieldName);
    const Value& operator [](size_t fieldId) const;
    const Value& operator [](const std::string& fieldName) const;

    const schema::Table& table() const { return *table_; }
    const std::string& key() const { return *fieldValues_[PRIMARY_KEY_ID]; }
    size_t size() const { return table().size(); }

    bool empty() const;
    bool broken() const;
    bool valid() const;
    bool completed() const;
    bool toDelete() const;

private:
    std::vector<Value> fieldValues_;
    const schema::Table* table_;

    friend class Table;
    friend std::ostream& operator << (std::ostream& stream, const Record& record);
};

using Records = std::list<Record>;

} // namespace maps::wiki::json2ymapsdf::ymapsdf
