#include "column.h"

#include <utility>

#include "pqxx.h"
#include "table.h"

namespace maps::wiki::json2ymapsdf::ymapsdf::schema {

Column::Column(
        const Table* table,
        std::string name,
        std::string defaultValue,
        bool isPrimary,
        Type type,
        const Table* foreign,
        bool isService)
    : name_(std::move(name))
    , defaultValue_(std::move(defaultValue))
    , id_(isPrimary ? PRIMARY_KEY_ID : table->size())
    , isPrimary_(isPrimary)
    , isService_(isService)
    , type_(type)
    , foreignTable_(foreign)
    , table_(table)
{ }

bool
Column::operator< (const Column& rhs) const
{
    if (table_ == rhs.table_) {
        return id() < rhs.id();
    }
    return table().name() < rhs.table().name();
}

} // namespace maps::wiki::json2ymapsdf::ymapsdf::schema
