#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/helpers.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/log.h>
#include "type.h"

#include <set>
#include <string>

namespace maps::wiki::json2ymapsdf::ymapsdf {

const std::string VALUE_NULL = "NULL";
const std::string VALUE_EMPTY = "";
const std::string VALUE_TRUE = "true";
const std::string VALUE_FALSE = "false";
const std::string PRIMARY_KEY = "PRIMARY_KEY";
const std::string DELETE = "DELETE";

const size_t PRIMARY_KEY_ID = 0;
const size_t DELETE_ID = 1;

namespace schema {

class Table;

class Column {
public:
    Column(
        const Table* table,
        std::string name,
        std::string defaultValue,
        bool isPrimary,
        Type type,
        const Table* foreign,
        bool isService);

    Column(Column&&) = default;
    Column(const Column&) = delete;
    Column& operator = (Column&&) = default;
    Column& operator = (const Column&) = delete;

    const std::string& name() const { return name_; }
    const std::string& defaultValue() const { return defaultValue_; }
    size_t id() const { return id_; }
    bool isPrimary() const { return isPrimary_; }
    bool isService() const { return isService_; }
    const Table* foreignPtr() const { return foreignTable_; }
    bool isKey() const { return foreignTable_ != nullptr || isPrimary_; }
    Type type() const { return type_; }
    const Table& table() const { return *table_; }

    bool operator< (const Column& rhs) const;

private:
    std::string name_;
    std::string defaultValue_;
    size_t id_;
    bool isPrimary_;
    bool isService_;
    Type type_;
    const Table* foreignTable_;
    const Table* table_;
};


using ColumnSet = std::set<const ymapsdf::schema::Column *, PtrLess<Column>>;

} // namespace schema
} // namespace maps::wiki::json2ymapsdf::ymapsdf
