#pragma once

#include "schema.h"

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::wiki::json2ymapsdf::ymapsdf::schema {

class Constraints {
public:
    Constraints(
        pgpool3::Pool& pool,
        std::string connStr,
        std::string validationPath);

    void init(const std::string& schemaName, const std::string& schemaSql);

    void createIndexes(const std::string& schemaName, size_t threadCount) const;

    void validateUniqueIndexes(const std::string& schemaName, size_t threadCount) const;
    void validateIntegrityChecks(const std::string& schemaName, size_t threadCount) const;
    void validateSql(const std::string& schemaName, size_t threadCount) const;

    struct Index {
        std::string name;
        std::string table;
        std::vector<std::string> columns;
        bool isUnique;
        bool isPrimaryKey;
    };

    struct IntegrityCheck {
        std::string name;
        std::string table;
        std::string column;
        std::string foreignTable;
        std::string foreignColumn;
    };

private:
    pgpool3::Pool& pool_;
    const std::string connStr_;
    const std::string validationPath_;
    std::vector<Index> indexes_;
    std::vector<IntegrityCheck> integrityChecks_;
};

Constraints loadConstraints(pgpool3::Pool& pool, const Params& params);

} // namespace maps::wiki::json2ymapsdf::ymapsdf::schema
