#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/transform/id_manager.h> // DBID

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::wiki::json2ymapsdf::ymapsdf::schema {

namespace column {
extern const std::string COLUMN_NAME;
extern const std::string COLUMN_NUM;
extern const std::string COLUMN_TYPE;
extern const std::string CONSTRAINT_NAME;
extern const std::string DEFAULT_VALUE;
extern const std::string DEFINITION;
extern const std::string FOREIGN_TABLE_NAME;
extern const std::string FOREIGN_COLUMN_NAME;
extern const std::string INDEX_NAME;
extern const std::string IS_PRIMARY;
extern const std::string IS_SERVICE;
extern const std::string IS_UNIQUE;
extern const std::string TABLE_NAME;
} // namespace column

pqxx::result selectTablesData(
    const std::string& connStr,
    const std::string& schema);

pqxx::result selectIndexesData(
    const std::string& connStr,
    const std::string& schema);

pqxx::result selectIntegrityData(
    const std::string& connStr,
    const std::string& schema);

std::vector<DBID>
collectUniqueViolations(
    pgpool3::Pool& pool,
    const std::string& schema,
    const std::string& table,
    const std::vector<std::string>& columns);

std::vector<DBID>
collectForeignKeyViolations(
    pgpool3::Pool& pool,
    const std::string& schema,
    const std::string& table,
    const std::string& column,
    const std::string& foreignTable,
    const std::string& foreignColumn);

void dropDBSchema(
    const std::string& connStr,
    const std::string& name);

void createDBSchema(
    const std::string& connStr,
    const std::string& name,
    const std::string& schemaSql);

void setUnloggedTable(
    const std::string& connStr,
    const std::string& schemaName,
    const std::string& tableName);

} // namespace maps::wiki::json2ymapsdf::ymapsdf::schema
