#include "relation.h"

#include <sstream>

namespace maps::wiki::json2ymapsdf::ymapsdf::schema {

Relation::Relation(const Column& master, const Column& slave)
    : master_(&master)
    , slave_(&slave)
{ }

std::string
Relation::name() const
{
    std::ostringstream nameStr;

    nameStr << master().table().name() << "." << master().name()
        << " <== " << slave().table().name() << "." << slave().name();

    return nameStr.str();
}

std::string
Relation::info() const
{
    return name();
}

} // namespace maps::wiki::json2ymapsdf::ymapsdf::schema
