#pragma once
#include "table.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/log.h>

namespace maps::wiki::json2ymapsdf::ymapsdf::schema {

class Relation {
public:
    Relation(const Column& master, const Column& slave);
    const Column& master() const { return *master_; }
    const Column& slave() const { return *slave_; }
    const Table& table() const { return master_->table(); }

    std::string name() const;
    std::string info() const;

private:
    const Column* master_;
    const Column* slave_;
};

using Relations = std::vector<Relation>;

} // namespace maps::wiki::json2ymapsdf::ymapsdf::schema
