#pragma once

#include "column.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/log.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/helpers.h>

#include <map>
#include <vector>

namespace maps::wiki::json2ymapsdf::ymapsdf::schema {

class Schema;

class Table {
public:
    explicit Table(const Schema* schema, std::string name);
    Table(Column&&) = delete;
    Table(const Table&) = delete;
    Table& operator = (Table&&) = delete;
    Table& operator = (const Table&) = delete;

    const std::string& name() const { return name_; }

    Column& operator[](const std::string& columnName);
    Column& operator[](size_t id);
    const Column& operator[](const std::string& columnName) const;
    const Column& operator[](size_t id) const;

    bool hasColumn(const std::string& columnName) const;
    const std::vector<Column>& columns() const { return columns_; }
    size_t size() const { return columns_.size(); }
    const Column& primary() const;
    std::vector<const Column*> foreign() const;
    std::vector<std::string> columnNames() const;

    void addColumn(Column&& column);

    bool operator<(const Table& rhs) const;

    std::string insertClause() const;

private:
    const Schema* schema_;
    std::string name_;
    std::vector<Column> columns_;
    std::map<std::string, size_t> columnNames_;
};

using TableSet = std::set<const ymapsdf::schema::Table *, PtrLess<Table>>;

} // namespace maps::wiki::json2ymapsdf::ymapsdf::schema
