#pragma once
#include "schema.h"

namespace maps::wiki::json2ymapsdf::ymapsdf {

class Value {
public:
    explicit Value(const schema::Column& column);
    Value(std::string& value, const schema::Column& column);
    Value(const Value& value) = default; 

    Value& operator =(const Value& value);

    Value& operator =(bool value);
    Value& operator =(int64_t value);
    Value& operator =(double value);
    Value& operator =(const std::string& value);

    const std::string& operator *() const;
    const schema::Column& column() const { return column_; }
    bool operator ==(const Value& v) const;


    bool empty() const { return value_.empty(); }
    bool filled() const { return filled_; }
    bool valid() const;
    bool hasDefault() const;

    void touch();

private:
    const schema::Column& column_;
    std::string value_;
    bool filled_;
};

} // namespace maps::wiki::json2ymapsdf::ymapsdf
