OWNER(gagauzev)

EXECTEST()

SET(JSON2YMAPSDF_CFG_DIR maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/cfg/packages/test)
SET(JSON_DATA_DIR ${ARCADIA_ROOT}/maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/tests/export_ft)

DEPENDS(
    contrib/tools/xmllint
    ${JSON2YMAPSDF_CFG_DIR}
    maps/doc/schemas/ymapsdf/garden
    maps/doc/schemas/ymapsdf/package
    maps/wikimap/mapspro/cfg/editor
    maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/bin
    maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/cfg/packages/test
    maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/tests/ft_tool
)

DATA(
    arcadia/maps/doc/schemas/ymapsdf
    arcadia/maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/cfg
    arcadia/maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/tests/export_ft/export_masstransit_wo_split
    arcadia/maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/tests/export_ft/export_poi_wo_split
    arcadia/maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/tests/export_ft/export_ymapsdf_with_split
    arcadia/maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/tests/export_ft/export_ymapsdf_wo_split
)

RUN(
    NAME export-ymapsdf-without-split
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_ymapsdf/json2ymapsdf.xml
        --json-dir ${JSON_DATA_DIR}/export_ymapsdf_wo_split
    CANONIZE_LOCALLY out.sql
)

RUN(
    NAME export-ymapsdf-with-split-cis1
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_ymapsdf/json2ymapsdf.xml
        --json-dir ${JSON_DATA_DIR}/export_ymapsdf_with_split
        --region cis1
    CANONIZE_LOCALLY out.sql
)

RUN(
    NAME export-ymapsdf-with-split-tr
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_ymapsdf/json2ymapsdf.xml
        --json-dir ${JSON_DATA_DIR}/export_ymapsdf_with_split
        --region tr
        --run-without-regions-list
    CANONIZE_LOCALLY out.sql
)

RUN(
    NAME export-masstransit-without-split
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_masstransit/json2ymapsdf.xml
        --json-dir ${JSON_DATA_DIR}/export_masstransit_wo_split
    CANONIZE_LOCALLY out.sql
)

RUN(
    NAME export-poi-without-split
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_poi/json2ymapsdf.xml
        --json-dir ${JSON_DATA_DIR}/export_poi_wo_split
    CANONIZE_LOCALLY out.sql
)

RUN(
    NAME print-export-ymapsdf-configuration
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_ymapsdf/json2ymapsdf.xml
        --print-configuration cfg.json
    CANONIZE_LOCALLY cfg.json
)

RUN(
    NAME print-export-masstransit-configuration
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_masstransit/json2ymapsdf.xml
        --print-configuration cfg.json
    CANONIZE_LOCALLY cfg.json
)

RUN(
    NAME print-export-poi-configuration
    ft_tool
        --config ${JSON2YMAPSDF_CFG_DIR}/export_poi/json2ymapsdf.xml
        --print-configuration cfg.json
    CANONIZE_LOCALLY cfg.json
)

INCLUDE(${ARCADIA_ROOT}/maps/libs/local_postgres/recipe.inc)

END()
