#pragma once

#include <boost/test/predicate_result.hpp>
#include <yandex/maps/wiki/unittest/query_helpers.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <set>

namespace maps::wiki::tests {

extern const std::string YMAPSDF_EXPORT_FILE;
extern const std::string YMAPSDF_CREATE_FILE;

namespace details {
struct ConnHolder {
    ConnHolder(pgpool3::ConnectionHandle conn) : conn(std::move(conn)) {}
    pgpool3::ConnectionHandle conn;
};
} // namespace details

class YmapsdfFixture: private details::ConnHolder, public unittest::QueryHelpers {
public:
    const std::string SCHEMA;

    YmapsdfFixture(
        pgpool3::ConnectionHandle connection,
        const std::string& schema,
        const std::string& sqlFile
    );
    ~YmapsdfFixture();

    void cleanTable(const std::string& table);
    void dropForeignKeys();
    void dropNotNullChecks();

    boost::test_tools::predicate_result
    hasIsocodes(const std::string& category, size_t id, const std::set<std::string>& expected);

    boost::test_tools::predicate_result
    tableHasOnlyIds(const std::string& table, const std::string& idColumn, const std::set<size_t>& expected);

private:
    template<typename T>
    boost::test_tools::predicate_result
    compare(const std::set<T>& expected, const std::set<T>& got);

    template<typename T>
    std::string
    expectedVsGot(const std::set<T>& expected, const std::set<T>& got);
};

} // namespace maps::wiki::tests
