#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/transform/id_manager.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::wiki::json2ymapsdf::test {

Y_UNIT_TEST_SUITE(test_IdManager)
{

Y_UNIT_TEST(IdManagerTest)
{
    idManager().advanceTo(120);
    EXPECT_EQ(idManager().uniqueDBID(), 121);
    EXPECT_EQ(idManager().uniqueDBID(), 122);
    EXPECT_EQ(idManager().uniqueDBID(30), 30);
    EXPECT_EQ(idManager().uniqueDBID(30), 123);
    EXPECT_EQ(idManager().uniqueDBID(), 124);
    EXPECT_EQ(idManager().uniqueDBID(30), 125);

    idManager().roundUp();
    EXPECT_EQ(idManager().uniqueDBID(), 201);

    idManager().roundUp();
    EXPECT_EQ(idManager().uniqueDBID(), 301);

    while (idManager().uniqueDBID() != 999) { }
    idManager().roundUp();
    EXPECT_EQ(idManager().uniqueDBID(), 1101);

    while (idManager().uniqueDBID() != 12345) { }
    idManager().roundUp();
    EXPECT_EQ(idManager().uniqueDBID(), 12501);
}

}

} // namespace maps::wiki::json2ymapsdf::test
