#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/pl2ymapsdf/builder.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/pl2ymapsdf/common.h>

#include <maps/libs/cmdline/include/cmdline.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/string_utils.h>

#include <vector>

int main(int argc, char* argv[])
{
    using namespace maps::wiki::pl2ymapsdf;

    const auto ALL_STAGES = maps::wiki::common::join(
        std::vector<std::string>{
            STAGE_ALL,
            STAGE_ATD,
        }, '|');

    try {
        maps::cmdline::Parser parser;
        auto connStr = parser.string("conn")
            .help("connection string to DB").required();
        auto srcSchema = parser.string("src")
            .help("source schema name");
        auto dstSchema = parser.string("dst")
            .defaultValue("ymapsdf")
            .help("destination YMAPSDF schema name");
        auto stages = parser.string("stages")
            .defaultValue("all")
            .help("csv-string: " + ALL_STAGES);
        parser.parse(argc, argv);

        buildYMapsDF(connStr, srcSchema, dstSchema, stages);
        return 0;
    } catch (const maps::Exception& mex) {
        ERROR() << mex;
    } catch (const std::exception& ex) {
        ERROR() << ex.what();
    } catch (...) {
        ERROR() << "Unknown exception";
    }
    return 1;
}

